<?php

//  如果侧边栏组件为空就使用默认设置
if ($this->options->SidebarComponent) {
    $components =$this->options->SidebarComponent;
}else{
    $components = '统计,分类列表,标签云';//统计,分类列表,最新评论,标签云
}
$components = str_replace(' ', '', $components);  //  去除空格
$components = str_replace('，', ',', $components);  //  兼容中文逗号
$components = explode(',', $components);
$components = array_filter($components);//去除空数组，避免小白设置错误

if(!$this->is('index')&&$this->currentPage==1){
    $components = array_diff($components,array("友情链接"));
}

$count = count($components); // 获取数组元素个数
$index = 0; // 计数器变量
?>
 <?php foreach ($components as $component):
    $index++;$sticky='';
    if ($index == $count) {$sticky=':class="\'sticky \'+top"';}
    ?>
     

<?php if ($component == '统计'): ?>
<!--统计-->
<?php $stat = \Widget\Stat::alloc(); ?>
<div <?php echo $sticky; ?> class="group p-3 rounded-lg -mx-1 mb-5 sm:mb-6 bg-white dark:bg-gray-900 dark:text-white text-sm shadow text-center">
<img alt="站长头像" class="max-w-42 w-full h-full rounded-lg object-cover mx-auto mb-3" src="<?php if($this->options->tx){$this->options->tx();}else{$this->options->themeUrl('img/logo.webp');} ?>" decoding="async" loading="lazy">

<h2 class="text-xl font-semibold mb-1"><?php $this->options->title(); ?></h2>
<div class="mx-auto bg-[var(--primary)] h-1 w-5 rounded-full mb-2"></div>
<p class="text-sm text-gray-400"><?php if($this->options->subtitle){$this->options->subtitle();}else{echo '站长很懒什么也没写';}?></p>

<div class="border-t border-gray-200 dark:border-gray-700 mt-3 pt-1">

<table class="text-center my-2 w-full serif-font">
                        <tbody><tr class="w-ful text-lg">
                            <th>文章</th>
                            <th>评论</th>
                            <th>标签</th>
                        </tr>
                        <tr class="text-gray-400">
                            <td class="pt-0.5"><?php $stat->publishedPostsNum(); ?></td>
                            <td class="pt-0.5"><?php $stat->PublishedCommentsNum(); ?></td>
                            <td class="pt-0.5"><?php $stat->tagsNum(); ?></td>
                        </tr>
                    </tbody></table>
</div>

</div>
<?php endif; ?>


<?php if ($component == '分类列表'): ?>
<!-- 父分类列表 -->
<div <?php echo $sticky; ?> class="group p-3 rounded-lg mb-5 sm:mb-6 bg-white dark:bg-gray-900 dark:text-white text-base shadow">
<?php getTitleTemplate($component);?>

      <?php
      $this->widget('Widget_Metas_Category_List')->to($cates); ?>
		<?php if($cates->have()): ?>
		<div>
		<?php while ($cates->next()): ?>
            <?php if ($cates->levels === 0): ?>
            <a href="<?php $cates->permalink(); ?>"  title="<?php $cates->count(); ?> 篇文章" class="dark:hover:text-[var(--primary)] hover:text-[var(--primary)] active:bg-[var(--btn-plain-bg-active)] hover:bg-[var(--btn-plain-bg-hover)] flex justify-between items-center px-3 py-2 text-sm rounded-lg dark:text-gray-300 duration-500">
            <span class="font-medium"><?php $cates->name(); ?></span>
            <span class="bg-[var(--btn-plain-bg-hover)] dark:bg-[var(--primary)] dark:text-[var(--deep-text)] p-2 text-xs rounded-lg"><?php $cates->count(); ?></span>
        </a>
        <?php endif; ?>
		<?php endwhile; ?>
		</div>
		<?php else: ?>
<div class="text-sm text-center text-gray-400">暂无分类</div>

		<?php endif; ?>
</div>
<?php endif; ?>


<?php if ($component == '标签云'): ?>
<!--标签云-->
<div <?php echo $sticky; ?> class="group p-3 rounded-lg -mx-1 mb-5 sm:mb-6 bg-white dark:bg-gray-900 dark:text-white text-base shadow">
<?php getTitleTemplate($component);?>
      <?php
        $this->widget('Widget_Metas_Tag_Cloud@righttags', 'ignoreZeroCount=1&desc=1&limit=25')->to($tags); ?>
		<?php if($tags->have()): ?>
		<div class="">
		<?php while ($tags->next()): ?>
			<a href="<?php $tags->permalink(); ?>" rel="tag" class="bg-[var(--btn-regular-bg)] text-[var(--btn-content)] mx-1 mb-1 mt-2 text-xs inline-block py-2 px-2.5 leading-none  whitespace-nowrap align-baseline font-bold rounded-lg" title="<?php $tags->count(); ?> 篇文章">#<?php $tags->name(); ?></a>
		<?php endwhile; ?>
		</div>
		<?php else: ?>
<div class="text-sm text-center text-gray-400 mt-2">暂无标签</div>

		<?php endif; ?>
</div>
<?php endif; ?>






<?php if ($component == '最新评论'): ?>
<!--最新评论-->
<?php $this->widget('Widget_Comments_Recent', 'pageSize=5&ignoreAuthor=true&parentId=')->to($comments); ?>
<div <?php echo $sticky; ?> class="group p-3 rounded-lg -mx-1 mb-5 sm:mb-6 bg-white dark:bg-gray-900 dark:text-white text-base shadow">

<?php getTitleTemplate($component);?>

<?php if ($comments->have()): ?>
<?php while($comments->next()): ?>
<div class="pb-2 mt-2">
<div class="flex">
 <a href="<?php $comments->permalink(); ?>" class="relative">
     <img class="relative z-10 size-10 border-2 border-gray-200 rounded-full scrollLoading mr-1" src="<?php echo tx($comments->mail,"blank"); ?>" alt="<?php echo $comments->author; ?>">
    <img class="absolute top-0 left-0 size-10 object-cover border-2 border-gray-200 rounded-full scrollLoading mr-1" src="<?php echo letter_avatarx($comments->author); ?>" alt="<?php echo $comments->author; ?>" x-cloak>
        </a>
<div class="flex flex-col">
<a href="<?php $comments->permalink(); ?>" class="flex-1 font-medium"><?php $comments->author(false); ?></a>
<time class="text-xs text-gray-500"><?php $comments->date('Y-m-d'); ?></time>
</div>
</div>
<div  class="mt-2 px-2.5 py-2 text-xs bg-gray-100/70 dark:bg-white/20 text-gray-400 w-full rounded-md">
<a href="<?php $comments->permalink(); ?>" class="block line-2">
<?php 
            $text=parseBiaoQing($comments->text);
             if(strpos($text,'$私密$') !== false){
             $text='该评论为私密评论，仅文章作者与评论发起者可见！';
             }
echo $text; ?></a>
</div>
</div>
<?php endwhile; ?>

<?php else: ?>
<div class="mt-2 text-sm text-center text-gray-400">暂无评论</div>
<?php endif; ?>
</div>
<?php endif; ?>


<?php endforeach;  ?>


