<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>响应式文件管理器</title>
    <style>
        /* 响应式基础样式 */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Microsoft YaHei", sans-serif;
        }
        body {
            background-color: #f8f9fa;
            padding: 20px;
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 15px rgba(0,0,0,0.05);
            padding: 25px;
        }
        /* 标题样式 */
        h2 {
            color: #333;
            font-size: 1.5rem;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        /* 提示框样式 */
        .alert {
            padding: 12px 18px;
            border-radius: 6px;
            margin-bottom: 20px;
            font-size: 0.95rem;
            display: none;
        }
        .alert.success {
            background-color: #d1fae5;
            color: #059669;
            display: block;
        }
        .alert.error {
            background-color: #fee2e2;
            color: #dc2626;
            display: block;
        }
        /* 文件列表样式 */
        .file-list {
            list-style: none;
        }
        .file-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 12px 15px;
            border-bottom: 1px solid #f1f1f1;
            font-size: 0.95rem;
        }
        .file-item:hover {
            background-color: #fafafa;
        }
        .file-info {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .file-icon {
            font-size: 1.2rem;
        }
        .dir-name {
            color: #6b7280;
        }
        /* 删除按钮样式 */
        .delete-btn {
            padding: 6px 14px;
            background-color: #ef4444;
            color: #fff;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 0.9rem;
            transition: background-color 0.2s;
            text-decoration: none;
        }
        .delete-btn:hover {
            background-color: #dc2626;
        }
        /* 手机适配 */
        @media (max-width: 768px) {
            .container {
                padding: 15px;
            }
            h2 {
                font-size: 1.3rem;
            }
            .file-item {
                padding: 10px 12px;
                font-size: 0.9rem;
            }
            .delete-btn {
                padding: 5px 10px;
                font-size: 0.85rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <?php
        // 1. 定义当前文件夹路径（PHP文件所在目录）
        $currentDir = __DIR__;
        // 2. 扫描文件夹，过滤掉 "." 和 ".."
        $fileList = scandir($currentDir);
        $validFiles = array_filter($fileList, function($item) {
            return $item !== '.' && $item !== '..';
        });
        // 3. 初始化提示信息
        $alertMsg = '';
        $alertStatus = '';

        // 4. 处理文件删除请求（通过GET参数触发）
        if (isset($_GET['delete'])) {
            $deleteFileName = trim($_GET['delete']);
            $deleteFilePath = $currentDir . DIRECTORY_SEPARATOR . $deleteFileName;

            // 安全校验：防止跨目录删除、确认是文件、文件存在
            if (
                file_exists($deleteFilePath) &&
                is_file($deleteFilePath) &&
                strpos(realpath($deleteFilePath), realpath($currentDir)) === 0
            ) {
                // 执行删除，判断是否成功
                if (unlink($deleteFilePath)) {
                    $alertMsg = "文件「{$deleteFileName}」删除成功！";
                    $alertStatus = 'success';
                } else {
                    $alertMsg = "文件「{$deleteFileName}」删除失败，权限不足！";
                    $alertStatus = 'error';
                }
            } else {
                $alertMsg = "删除失败：文件不存在、是目录或非法路径！";
                $alertStatus = 'error';
            }
        }
        ?>

        <!-- 操作提示框 -->
        <?php if ($alertMsg): ?>
            <div class="alert <?php echo $alertStatus; ?>"><?php echo $alertMsg; ?></div>
        <?php endif; ?>

        <!-- 目录标题 -->
        <h2>当前目录：<?php echo $currentDir; ?></h2>

        <!-- 文件列表 -->
        <ul class="file-list">
            <?php foreach ($validFiles as $file): ?>
                <?php $filePath = $currentDir . DIRECTORY_SEPARATOR . $file; ?>
                <li class="file-item">
                    <div class="file-info">
                        <!-- 区分文件/目录图标 -->
                        <span class="file-icon"><?php echo is_file($filePath) ? '📄' : '📂'; ?></span>
                        <!-- 区分文件/目录文字样式 -->
                        <span><?php echo is_file($filePath) ? $file : "<span class='dir-name'>{$file}（目录）</span>"; ?></span>
                    </div>
                    <!-- 仅文件显示删除按钮 -->
                    <?php if (is_file($filePath)): ?>
                        <a 
                            href="?delete=<?php echo urlencode($file); ?>" 
                            class="delete-btn"
                            onclick="return confirm('确定要永久删除「<?php echo $file; ?>」吗？')"
                        >
                            删除
                        </a>
                    <?php endif; ?>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>
</body>
</html>
