/* InstantClick 3.2.0 | (C) 2024 Alexandre Dieulot | http://instantclick.io/license */
/* 泽泽开光版2023.12.27~2025.03 */

var instantClick
  , InstantClick = instantClick = function(document, location) {
  // Internal variables
  var $ua = navigator.userAgent,
      $isChromeForIOS = $ua.indexOf(' CriOS/') > -1,
      $hasTouch = 'createTouch' in document,
      $currentLocationWithoutHash,
      $urlToPreload,
      $preloadTimer,
      $lastTouchTimestamp,//上次触摸时间
      $x=0,
      $y=0,

  // Preloading-related variables
      $history = {},
      $xhr,
      $url = false,
      $title = false,
      $mustRedirect = false,
      $body = false,
      $timing = {},
      $isPreloading = false,
      $isWaitingForCompletion = false,
      $trackedAssets = [],

  // Variables defined by public functions
      $useWhitelist,
      $preloadOnMousedown,
      $delayBeforePreload,
      $pjaxcontainer,
      $eventsCallbacks = {
        fetch: [],
        receive: [],
        wait: [],
        forward:[],
        change: [],
        restore: []
      }


  ////////// HELPERS //////////


  function removeHash(url) {
    var index = url.indexOf('#')
    if (index == -1) {
      return url
    }
    return url.substr(0, index)
  }

  function getParentLinkElement(target) {
    while (target && target.nodeName != 'A') {
      target = target.parentNode
    }
    return target
  }

  function isBlacklisted(elem) {
    do {
      if (!elem.hasAttribute) { // Parent of <html>
        break
      }
      if (elem.hasAttribute('data-instant')) {
        return false
      }
      if (elem.hasAttribute('data-no-instant')) {
        return true
      }
    }
    while (elem = elem.parentNode)
    return false
  }

  function isWhitelisted(elem) {
    do {
      if (!elem.hasAttribute) { // Parent of <html>
        break
      }
      if (elem.hasAttribute('data-no-instant')) {
        return false
      }
      if (elem.hasAttribute('data-instant')) {
        return true
      }
    }
    while (elem = elem.parentNode)
    return false
  }

  function isPreloadable(a) {//可预加载的
    var domain = location.protocol + '//' + location.host

    if ((a.target&&a.target!="_self") // target="_blank" etc.
        || a.hasAttribute('download')
        || a.href.indexOf(domain + '/') != 0 // Another domain, or no href attribute
        || (a.href.indexOf('#') > -1
            && removeHash(a.href) == $currentLocationWithoutHash) // Anchor
        || ($useWhitelist
            ? !isWhitelisted(a)
            : isBlacklisted(a))
       ) {
      return false
    }
    return true
  }

  function triggerPageEvent(eventType, arg1, arg2, arg3) {
    var returnValue = false
    for (var i = 0; i < $eventsCallbacks[eventType].length; i++) {
      if (eventType == 'receive') {
        var altered = $eventsCallbacks[eventType][i](arg1, arg2, arg3)
        if (altered) {
          /* Update args for the next iteration of the loop. */
          if ('body' in altered) {
            arg2 = altered.body
          }
          if ('title' in altered) {
            arg3 = altered.title
          }

          returnValue = altered
        }
      }
      else {
        $eventsCallbacks[eventType][i](arg1, arg2, arg3)
      }
    }
    return returnValue
  }

  //页面改变时替换页面内容，标题，body，网址，滚动条
  function changePage(title, body, newUrl, scrollY, pop) {
    //console.log(scrollY)
    if($pjaxcontainer){
    var mainElement = body.querySelector($pjaxcontainer);
    var currentMainElement = document.querySelector($pjaxcontainer);
// 替换当前页面id为main的内容
if (mainElement && currentMainElement) {
  var instantClickElement = document.getElementById('instantclick');
  if (instantClickElement) {
      instantClickElement.remove();
  }
    currentMainElement.innerHTML = mainElement.innerHTML;
}
}
else {
  document.documentElement.replaceChild(body, document.body)
}
    /* We cannot just use `document.body = doc.body`, it causes Safari (tested
       5.1, 6.0 and Mobile 7.0) to execute script tags directly.
    */

    if (newUrl) {
      if (newUrl != location.href) {
        history.pushState(null, null, newUrl)
      }

      var hashIndex = newUrl.indexOf('#'),
          hashElem = hashIndex > -1
                     && document.getElementById(newUrl.substr(hashIndex + 1)),
          offset = 0

      if (hashElem) {
        while (hashElem.offsetParent) {
          offset += hashElem.offsetTop

          hashElem = hashElem.offsetParent
        }
      }
      if ('requestAnimationFrame' in window) {
        /* Safari on macOS doesn't immediately visually change the page on
         * `document.documentElement.replaceChild`, so if `scrollTo` is called
         * without `requestAnimationFrame` it often scrolls before the page
         * is displayed.
         */
        requestAnimationFrame(function() {
          scrollTo(0, offset)
        })
      }
      else {
        scrollTo(0, offset)
        /* Safari on macOS scrolls before the page is visually changed, but
         * adding `requestAnimationFrame` doesn't fix it in this case. */
      }

      $currentLocationWithoutHash = removeHash(newUrl)
    }
    else {
      scrollTo(0, scrollY)
    }

    if ($isChromeForIOS && document.title == title) {
      /* Chrome for iOS:
       *
       * 1. Removes title on pushState, so the title needs to be set after.
       *
       * 2. Will not set the title if it’s identical when trimmed, so
       *    appending a space won't do, but a non-breaking space works.
       */
      document.title = title + String.fromCharCode(160)
    }
    else {
      document.title = title
    }

    instantanize()
    bar.done()
    if (pop) {
      /* iOS's gesture to go back by swiping from the left edge of the screen
       * will start a preloading if the user touches a link, it needs to be
       * cancelled otherwise the page behind the touched link will be
       * displayed.
       */
      $xhr.abort()
      setPreloadingAsHalted()
      triggerPageEvent('restore')
      triggerPageEvent('change', false)
    }
    else {
      triggerPageEvent('forward')
      triggerPageEvent('change', false)
    }

  }

  function setPreloadingAsHalted() {
    $isPreloading = false
    $isWaitingForCompletion = false
  }

  function removeNoscriptTags(html) {
    /* Must be done on text, not on a node's innerHTML, otherwise strange
     * things happen with implicitly closed elements (see the Noscript test).
     */
    return html.replace(/<noscript[\s\S]+?<\/noscript>/gi, '')
  }


  ////////// EVENT HANDLERS //////////

  function mousedown(event) {//鼠标按下
    if ($lastTouchTimestamp > (+new Date - 500)) {
      return // 否则，点击不会触发
    }

    var linkElement = getParentLinkElement(event.target)

    if (!linkElement || !isPreloadable(linkElement)) {
      return
    }

    preload(linkElement.href)
  }

  function mouseover(event) {//鼠标移入

    if ($lastTouchTimestamp > (+new Date - 500)) {
      return // 否则，点击不会触发
    }

    if (getParentLinkElement(event.target) == getParentLinkElement(event.relatedTarget)) {
      /* Happens when mouseout-ing and mouseover-ing child elements of the same link element */
      return
    }
    var linkElement = getParentLinkElement(event.target)

    if (!linkElement || !isPreloadable(linkElement)) {
      return
    }

    linkElement.addEventListener('mouseout', mouseout)

    if (!$delayBeforePreload) {
      preload(linkElement.href)
    }
    else {
      $urlToPreload = linkElement.href
      $preloadTimer = setTimeout(preload, $delayBeforePreload)
    }
  }

  function touchstart(e) {//触摸开始
    $lastTouchTimestamp = +new Date;//=+表示右侧转为数值复制给左侧

    var a = getParentLinkElement(e.target)

    if (!a || !isPreloadable(a)) {
      return
    }

    preload(a.href)
  }
  function mousedownstart(e){
$x=+e.clientX;
$y=+e.clientY;
  }



  function click(e) {
    var a = getParentLinkElement(e.target)

      // 计算移动的距离,求绝对值
      const distanceX = Math.abs($x - e.clientX);
      const distanceY = Math.abs($y - e.clientY);

        // 设定一个阈值，小于这个值可以认为是点击
      const clickThreshold = 5; // 可以根据需要调整这个阈值
        
      if (distanceX >= clickThreshold || distanceY >= clickThreshold) {
          //console.log('Move event');
          return
      }

    if (!a || !isPreloadable(a)) {
      return
    }

    /* Check if it's opening in a new tab */
    if (e.button != 0 // Chrome < 55 fires a click event when the middle mouse button is pressed
      || e.metaKey
      || e.ctrlKey) {
      return
    }
    e.preventDefault()
    display(a.href)
  }

  function mouseout(e) {//鼠标离开
    if (getParentLinkElement(e.target) == getParentLinkElement(e.relatedTarget)) {
      /* Happens when mouseout-ing and mouseover-ing child elements of the same link element,
         we don't want to stop preloading then. */
      return
    }
    if ($preloadTimer) {
      clearTimeout($preloadTimer)
      $preloadTimer = false
      return
    }

    if (!$isPreloading || $isWaitingForCompletion) {
      return
    }
    $xhr.abort()
    setPreloadingAsHalted()
  }

  function readystatechange() {
    if ($xhr.readyState < 4) {
      return
    }
    if ($xhr.status == 0) {
      /* Request error/timeout/abort */
      if ($isWaitingForCompletion) {
        location.href = $url
      }
      return
    }

    $timing.ready = +new Date - $timing.start

    var contentType = $xhr.getResponseHeader('Content-Type')
    if (contentType && /^text\/html/i.test(contentType)) {
      var doc = document.implementation.createHTMLDocument('')
      doc.documentElement.innerHTML = removeNoscriptTags($xhr.responseText)
      $title = doc.title
      $body = doc.body

      var alteredOnReceive = triggerPageEvent('receive', $url, $body, $title)
      if (alteredOnReceive) {
        if ('body' in alteredOnReceive) {
          $body = alteredOnReceive.body
        }
        if ('title' in alteredOnReceive) {
          $title = alteredOnReceive.title
        }
      }

      var urlWithoutHash = removeHash($url)
      $history[urlWithoutHash] = {
        body: $body,
        title: $title,
        scrollY: urlWithoutHash in $history ? $history[urlWithoutHash].scrollY : 0
      }

      //console.log($history[urlWithoutHash]);
      var elems = doc.head.children,
          found = 0,
          elem,
          data

      for (var i = 0; i < elems.length; i++) {
        elem = elems[i]
        if (elem.hasAttribute('data-instant-track')) {
          data = elem.getAttribute('href') || elem.getAttribute('src') || elem.innerHTML
          for (var j = 0; j < $trackedAssets.length; j++) {
            if ($trackedAssets[j] == data) {
              found++
            }
          }
        }
      }
      if (found != $trackedAssets.length) {
        $mustRedirect = true // Assets have changed
      }
    }
    else {
      $mustRedirect = true // Not an HTML document
    }

    if ($isWaitingForCompletion) {
      $isWaitingForCompletion = false
      display($url)
    }
  }


  ////////// MAIN FUNCTIONS //////////


  function instantanize(isInitializing) {
    document.body.addEventListener('touchstart', touchstart, true);//触摸事件

    document.body.addEventListener('mousedown', mousedownstart, true);//调用鼠标点击事件


    if ($preloadOnMousedown) {//如果使用点击预载
      document.body.addEventListener('mousedown', mousedown, true);//调用鼠标点击事件
    }
    else {
      document.body.addEventListener('mouseover', mouseover, true);//调用鼠标移入事件
    }

    document.body.addEventListener('click', click, true);//点击事件载入预载的内容

    if (!isInitializing) {
      var scriptsInDOM = document.body.getElementsByTagName('script')
        , scriptsToCopy = []
        ,  script
        ,  copy
        ,  parentNode
        ,  nextSibling

      /* `scriptsInDOM` will change during the copy of scripts if a script add
         or delete scripts, so we need to put scripts in an array to loop
         through them correctly.
      */
         for (i = 0; i < scriptsInDOM.length; i++) {
          scriptsToCopy.push(scriptsInDOM[i])
        }
  
        for (i = 0; i < scriptsToCopy.length; i++) {
          script = scriptsToCopy[i]
          if (!script) { // Might have disappeared, see previous comment
            continue
          }

        if (script.hasAttribute('data-no-instant')) {
          continue
        }
        copy = document.createElement('script')
        if (script.src) {
          copy.src = script.src
        }
        if (script.innerHTML) {
          copy.innerHTML = script.innerHTML
        }
        parentNode = script.parentNode
        nextSibling = script.nextSibling
        parentNode.removeChild(script)
        parentNode.insertBefore(copy, nextSibling)
      }
    }
  }

  function preload(url, calledOnDisplay) {
    if (!$preloadOnMousedown
        && 'display' in $timing
        && +new Date - ($timing.start + $timing.display) < 100
        && !calledOnDisplay) {
      /* After a page is displayed, if the user's cursor happens to be above
         a link a mouseover event will be in most browsers triggered
         automatically, and in other browsers it will be triggered when the
         user moves his mouse by 1px.

         Here are the behavior I noticed, all on Windows:
         - Safari 5.1: auto-triggers after 0 ms
         - IE 11: auto-triggers after 30-80 ms (depends on page's size?)
         - Firefox: auto-triggers after 10 ms
         - Opera 18: auto-triggers after 10 ms

         - Chrome: triggers when cursor moved
         - Opera 12.16: triggers when cursor moved

         To remedy to this, we do not start preloading if last display
         occurred less than 100 ms ago.
      */

      return
    }
    if ($preloadTimer) {
      clearTimeout($preloadTimer)
      $preloadTimer = false
    }

    if (!url) {
      url = $urlToPreload
    }

    if ($isPreloading && (url == $url || $isWaitingForCompletion)) {
      return
    }
    $isPreloading = true
    $isWaitingForCompletion = false

    $url = url
    $body = false
    $mustRedirect = false
    $timing = {
      start: +new Date
    }
    triggerPageEvent('fetch')
    $xhr.open('GET', url)
    $xhr.timeout = 90000 // Must be set after `open()` with IE
    $xhr.setRequestHeader("X-Requested-With", "instantclick")
    $xhr.send()
  }

  function display(url) {
    if (!('display' in $timing)) {
      $timing.display = +new Date - $timing.start
    }
    if ($preloadTimer || !$isPreloading) {
      /* $preloadTimer:
         Happens when there’s a delay before preloading and that delay
         hasn't expired (preloading didn't kick in).

         !$isPreloading:
         A link has been clicked, and preloading hasn’t been initiated.
         It happens with touch devices when a user taps *near* the link,
         Safari/Chrome will trigger mousedown, mouseover, click (and others),
         but when that happens we ignore mousedown/mouseover (otherwise click
         doesn’t fire). Maybe there’s a way to make the click event fire, but
         that’s not worth it as mousedown/over happen just 1ms before click
         in this situation.

         It also happens when a user uses his keyboard to navigate (with Tab
         and Return), and possibly in other non-mainstream ways to navigate
         a website.
      */

      if ($preloadTimer && $url && $url != url) {
        /* Happens when the user clicks on a link before preloading
           kicks in while another link is already preloading.
        */

        location.href = url
        return
      }

      preload(url, true)
      bar.start(0, true)
      triggerPageEvent('wait')
      $isWaitingForCompletion = true // Must be set *after* calling `preload`
      return
    }
    if ($isWaitingForCompletion) {
      /* The user clicked on a link while a page was preloading. Either on
         the same link or on another link. If it's the same link something
         might have gone wrong (or he could have double clicked, we don’t
         handle that case), so we send him to the page without pjax.
         If it's another link, it hasn't been preloaded, so we redirect the
         user to it.
      */
      location.href = url
      return
    }
    if ($mustRedirect) {
      location.href = $url
      return
    }
    if (!$body) {
      bar.start(0, true)
      triggerPageEvent('wait')
      $isWaitingForCompletion = true
      return
    }
    $history[$currentLocationWithoutHash].scrollY = scrollY 
    setPreloadingAsHalted()
    changePage($title, $body, $url)
  }


  ////////// PROGRESS BAR FUNCTIONS //////////


  var bar = function() {
    var $barContainer,
        $barElement,
        $barTransformProperty,
        $barProgress,
        $barTimer

    function init() {
      $barContainer = document.createElement('div')
      $barContainer.id = 'instantclick'
      $barElement = document.createElement('div')
      $barElement.id = 'instantclick-bar'
      $barElement.className = 'instantclick-bar'
      $barContainer.appendChild($barElement)

      var vendors = ['Webkit', 'Moz', 'O']

      $barTransformProperty = 'transform'
      if (!($barTransformProperty in $barElement.style)) {
        for (var i = 0; i < vendors.length; i++) {
          if (vendors[i] + 'Transform' in $barElement.style) {
            $barTransformProperty = vendors[i] + 'Transform'
          }
        }
      }

      var transitionProperty = 'transition'
      if (!(transitionProperty in $barElement.style)) {
        for (var i = 0; i < arguments.length; i++) {
          if (vendors[i] + 'Transition' in $barElement.style) {
            transitionProperty = '-' + vendors[i].toLowerCase() + '-' + transitionProperty
          }
        }
      }

      var style = document.createElement('style')
      style.innerHTML = '#instantclick{position:' + ($hasTouch ? 'absolute' : 'fixed') + ';top:0;left:0;width:100%;pointer-events:none;z-index:2147483647;' + transitionProperty + ':opacity .25s .1s}'
        + '.instantclick-bar{background:#29d;width:100%;margin-left:-100%;height:2px;' + transitionProperty + ':all .25s}'
      /* We set the bar's background in `.instantclick-bar` so that it can be
         overriden in CSS with `#instantclick-bar`, as IDs have higher priority.
      */
      document.head.appendChild(style)

      if ($hasTouch) {
        updatePositionAndScale()
        addEventListener('resize', updatePositionAndScale)
        addEventListener('scroll', updatePositionAndScale)
      }

    }

    function start(at, jump) {
      $barProgress = at
      if (document.getElementById($barContainer.id)) {
        document.body.removeChild($barContainer)
      }
      $barContainer.style.opacity = '1'
      if (document.getElementById($barContainer.id)) {
        document.body.removeChild($barContainer)
        /* So there's no CSS animation if already done once and it goes from 1 to 0 */
      }
      update()
      if (jump) {
        setTimeout(jumpStart, 0)
        /* Must be done in a timer, otherwise the CSS animation doesn't happen. */
      }
      clearTimeout($barTimer)
      $barTimer = setTimeout(inc, 500)
    }

    function jumpStart() {
      $barProgress = 10
      update()
    }

    function inc() {
      $barProgress += 1 + (Math.random() * 2)
      if ($barProgress >= 98) {
        $barProgress = 98
      }
      else {
        $barTimer = setTimeout(inc, 500)
      }
      update()
    }

    function update() {
      $barElement.style[$barTransformProperty] = 'translate(' + $barProgress + '%)'
      if (!document.getElementById($barContainer.id)) {
        document.body.appendChild($barContainer)
      }
    }

    function done() {
      if (document.getElementById($barContainer.id)) {
        clearTimeout($barTimer)
        $barProgress = 100
        update()
        $barContainer.style.opacity = '0'
        /* If you're debugging, setting this to 0.5 is handy. */
        return
      }

      /* The bar container hasn't been appended: It's a new page. */
      start($barProgress == 100 ? 0 : $barProgress)
      /* $barProgress is 100 on popstate, usually. */
      setTimeout(done, 0)
      /* Must be done in a timer, otherwise the CSS animation doesn't happen. */

    }

    function updatePositionAndScale() {
      /* Adapted from code by Sam Stephenson and Mislav Marohnić
         http://signalvnoise.com/posts/2407
      */

      $barContainer.style.left = scrollX + 'px'
      $barContainer.style.width = document.body.clientWidth + 'px'
      $barContainer.style.top = scrollY + 'px'

      var landscape = 'orientation' in window && Math.abs(orientation) == 90,
          scaleY = innerWidth / screen[landscape ? 'height' : 'width'] * 2
      /* We multiply the size by 2 because the progress bar is harder
         to notice on a mobile device.
      */
      $barContainer.style[$barTransformProperty] = 'scaleY(' + scaleY  + ')'
    }

    return {
      init: init,
      start: start,
      done: done
    }
  }()


  ////////// PUBLIC VARIABLE AND FUNCTIONS //////////

  var supported = 'pushState' in history
                  && (!$ua.match('Android') || $ua.match('Chrome/'))
                  && location.protocol != "file:"

  function init() {
    if ($currentLocationWithoutHash) {
      /* Already initialized */
      return
    }
    if (!supported) {
      triggerPageEvent('change', true)
      return
    }
    for (var i = 0; i < arguments.length; i++) {
      var arg = arguments[i]
      if (arg === true) {
        $useWhitelist = true
      }
      else if (arg == 'mousedown') {
        $preloadOnMousedown = true
      }
      else if (typeof arg == 'number') {
        $delayBeforePreload = arg
      }
      else if (arg.includes("#")){
        $pjaxcontainer = arg
      }
    }
    $currentLocationWithoutHash = removeHash(location.href)
    $history[$currentLocationWithoutHash] = {
      body: document.body,
      title: document.title,
      scrollY: scrollY
    }

    var elems = document.head.children,
        elem,
        data
    for (var i = 0; i < elems.length; i++) {
      elem = elems[i]
      if (elem.hasAttribute('data-instant-track')) {
        data = elem.getAttribute('href') || elem.getAttribute('src') || elem.innerHTML
        /* We can't use just `elem.href` and `elem.src` because we can't
           retrieve `href`s and `src`s from the Ajax response.
        */
        $trackedAssets.push(data)
      }
    }

    $xhr = new XMLHttpRequest()
    $xhr.addEventListener('readystatechange', readystatechange)

    instantanize(true)

    bar.init()

    triggerPageEvent('change', true)

    preload(location.href, true) //预加载下首页
    
    function popstateListener() {
      var loc = removeHash(location.href)
      if (loc == $currentLocationWithoutHash) {
        return
      }
  
      if (!(loc in $history)) {
        if (loc == location.href) { // no location.hash
          location.href = location.href
          /* Reloads the page while using cache for scripts, styles and images,
             unlike `location.reload()` */
        }else {
          /* When there's a hash, `location.href = location.href` won't reload
             the page (but will trigger a popstate event, thus causing an infinite
             loop), so we need to call `location.reload()` */
          location.reload()
        }
        return
      }
  
      $history[$currentLocationWithoutHash].scrollY = scrollY
      $currentLocationWithoutHash = loc
      changePage($history[loc].title, $history[loc].body, false, $history[loc].scrollY, true)
    }
    addEventListener('popstate', popstateListener)
  }

  function on(eventType, callback) {
    $eventsCallbacks[eventType].push(callback)
  }


  function insa(url) {
  preload(url, true)
  bar.start(0, true)
  triggerPageEvent('wait')
  $isWaitingForCompletion = true // // 必须在调用 `preload` 之后设置
  if (!$body) {return}
  $history[$currentLocationWithoutHash].scrollY = scrollY
  setPreloadingAsHalted()
  changePage($title, $body, $url)
  return
  }
  ////////////////////


  return {
    supported: supported,
    init: init,
    on: on,
    insa: insa,
  }

}(document, location);
